function initLanguage() {
    var scriptUrl = "";
    if (cameraSettings.ModelName == "VC-A71P-HN") {
        $("#Img_language").show();
    }
    var lang = sessionStorage.getItem("lang");
    console.log(lang);
    if (lang != "zh-tw" && lang != "zh-cn") {
        sessionStorage.setItem("lang", "en");
        lang = "en";
    }
    changeLanguage(lang);
}

function changeLanguage(lang) {
    var scriptUrl = "";
    sessionStorage.setItem("lang", lang);
    if (lang == "en") {
        document.getElementById("Img_language").src = "./images/EN.png";
    } else if (lang == "zh-tw") {
        document.getElementById("Img_language").src = "./images/TC.png";
    } else if (lang == "zh-cn") {
        document.getElementById("Img_language").src = "./images/SC.png";
    }
    scriptUrl = "/text/text_" + lang + ".js";
    $.getScript(scriptUrl, function () {
        InitLanguageOfMenu();
        InitLanguageOfPage();
    });
}

function InitLanguageOfMenu() {
    $("#powerBtn").attr('title', text['power']);
    $(".logout_Btn").attr('title', text['logout']);

    $('#Span_MenuLiveView').text(text['live_view']);
    $('#Span_MenuAudio').text(text['audio']);
    $('#Span_MenuStream').text(text['stream']);
    $('#Span_MenuSystem').text(text['system']);
    $('#Span_MenuDevice').text(text['device']);
    $('#Span_MenuOutput').text(text['output']);
    $('#Span_MenuNetwork').text(text['network']);
    $('#Span_MenuSecurity').text(text['security']);
    $('#Span_MenuDateTime').text(text['date_time']);
    $('#Span_MenuUser').text(text['user']);
    $('#Span_MenuControl').text(text['control']);
    $('#Span_MenuMaintenance').text(text['maintenance']);
    $('#Span_MenuReboot').text(text['reboot']);
    $('#Span_MenuAbout').text(text['about']);
}

function InitLanguageOfPage() {
    var page = sessionStorage.getItem("div_page");
    if (page == "Div_LeftLiveView") {
        $('#Label_LiveView').text(text['live_view']);
        $('#Label_Preset').text(text['preset']);
        $('#Span_Store').text(text['store']);
        $('#Label_DigitalZoom').text(text['digital_zoom']);
        $('#Label_Zoom').text(text['zoom']);
        $('#A_tabExposure').text(text['exposure']);
        $('#A_tabWhiteBalance').text(text['white_balance']);
        $('#A_tabFocus').text(text['focus']);
        $('#A_tabMirror').text(text['mirror']);
        $('#A_tabPTZ').text(text['ptz']);
        $('#A_tabPicture').text(text['picture']);
        $('#Label_ExposureMode').text(text['mode']);
        $('#Label_GainLevel').text(text['gain_level']);
        $('#Label_WDR').text(text['wdr']);
        $('#Label_ExposureCompLevel').text(text['exposure_comp_level']);
        $('#Label_IrisLevel').text(text['iris_level']);
        $('#Label_ShutterSpeed').text(text['shutter_speed']);
        $('#Label_WhiteBalanceMode').text(text['mode']);
        $('#Label_ManualRed').text(text['manual_red']);
        $('#Label_ManualBlue').text(text['manual_blue']);
        $('#onePushAwbButton').text(text['one_push']);
        $('#Label_AFSensitivity').text(text['af_sensitivity']);
        $('#Label_AFFrame').text(text['af_frame']);
        $('#Label_ZoomTracking').text(text['zoom_tracking']);
        $('#Label_PTZAssist').text(text['ptz_assist']);
        $('#Label_SmartAF').text(text['smart_af']);
        $('#onePushAfButton').text(text['one_push_af']);
        $('#Label_Mirror').text(text['mirror']);
        $('#Label_Flip').text(text['flip']);
        $('#Label_PanTiltLimit').text(text['pan_tilt_limit']);
        $('#Label_PanFlip').text(text['pan_flip']);
        $('#Label_TiltFlip').text(text['tilt_flip']);
        $('#Label_PresetSpeed').text(text['preset_speed']);
        $('#Label_PTZSpeedComp').text(text['ptz_speed_comp']);
        $('#Label_InitialPosition').text(text['initial_position']);
        $('#Label_MotionlessPreset').text(text['motionless_preset']);
        $('#Label_DZoomLimit').text(text['dzoom_limit']);
        $('#Label_PTZMotionSync').text(text['ptz_motion_sync']);
        $('#Label_PictureEffect').text(text['picture_effect']);
        $('#Label_ImageMode').text(text['image_mode']);
        $('#Label_ImageModeLoad').text(text['image_mode_load']);
        $('#Label_Hue').text(text['hue']);
        $('#Label_2DNR').text(text['_2d_nr']);
        $('#Label_Gamma').text(text['gamma']);
        $('#Label_Brightness').text(text['brightness']);
        $('#Label_3DNR').text(text['_3d_nr']);
        $('#Label_Saturation').text(text['saturation']);
        $('#Label_Sharpness').text(text['sharpness']);

        $(".toCtrlSetting_Btn").attr('title', text['camera_setting']);
        $(".toCtrlHome_Btn").attr('title', text['ptz_control']);

    } else if (page == "Div_LeftAudio") {
        $('#Label_Audio').text(text['audio']);
        $('#Span_AudioEnable').text(text['audio_enable']);
        $('#Label_AudioIn').text(text['audio_in']);
        $('#Label_EncodeType').text(text['encode_type']);
        $('#Label_EncodeSampleRate').text(text['encode_sample_rate']);
        $('#Label_AudioVolume').text(text['audio_volume']);
        $('#Span_AudioDelay').text(text['audio_delay']);
        $('#Label_AudioDelayTime').text(text['audio_delay_time'] + "(-)");
        $('#Label_ms').text(text['ms']);
        $('#Span_Apply').text(text['apply']);
        $('#Span_Cancel').text(text['cancel']);

    } else if (page == "Div_LeftStream") {
        $('#Label_Stream').text(text['stream']);
        //$('#A_tabStream').text(text['stream']);
        $('#A_tabNDI').text(text['ndi']);
        $('#ndiHB_tab').text(text['high_bandwidth_ndi']);
        $('#Label_StreamType').text(text['stream_type']);

        $('.streamAboutSpan').attr('title', text['rtmp_auth_hint'] + " \n1. " + text['rtmp_auth_hint1'] + " \n2. " + text['rtmp_auth_hint2']);
        $('#Label_VideoEncoderType').text(text['video_encoder_type'] + " : ");
        $('#Label_AudioEncoderType').text(text['audio_encoder_type'] + " : ");
        $('#Label_ResolutionFormat').text(text['resolution_format'] + " : ");
        $('#Label_ChunkSize').text(text['chunk_size'] + " : ");
        $('#Label_RTMP_RTMPS_ServerStatus').text(text['rtmp_rtmps_server_status'] + " : ");
        $('#Label_RtmpRequirePasswordAuthentication').text(text['require_password_authentication']);
        $('#Label_Account').text(text['account']);
        $('#Label_Password').text(text['password']);
        $('#Label_RtmpUrl').text(text['rtmp_url']);
        $('#Label_StreamKey').text(text['stream_key']);
        $('#Label_EnableMulticast').text(text['enable_multicast']);
        $('#Label_RequirePasswordAuthentication').text(text['require_password_authentication']);
        $('#Label_MpegtsIp').text(text['mpegts_ip']);
        $('#Label_MpegtsPort').text(text['port']);
        $('#Label_ConnectStatus').text(text['connect_status'] + " : ");
        $('#Label_ConnectionMode').text(text['connection_mode']);
        $('#Label_SrtUrl').text(text['url']);
        $('#Label_SrtPort').text(text['port']);
        $('#Label_StreamID').text(text['stream_id']);
        $('#Label_Latency').text(text['latency']);
        $('#Label_ms').text(text['ms']);
        $('#Label_Encryption').text(text['encryption']);
        $('#Label_Passphrase').text(text['passphrase']);

        $('#Label_Stream1').text(text['stream'] + "1");
        $('#Label_Codec1').text(text['codec'] + ":H.265");
        $('#Label_BitRate1').text(text['bit_rate']);
        $('#Label_Resolution1').text(text['resolution']);
        $('#Label_RateControl1').text(text['rate_control']);
        $('#Label_FrameRate1').text(text['frame_rate']);
        $('#Label_IPRatio1').text(text['ip_ratio']);
        $('#Label_Stream2').text(text['stream'] + "2");
        $('#Label_Codec2').text(text['codec'] + ":H.264");
        $('#Label_BitRate2').text(text['bit_rate']);
        $('#Label_Resolution2').text(text['resolution']);
        $('#Label_RateControl2').text(text['rate_control']);
        $('#Label_FrameRate2').text(text['frame_rate']);
        $('#Label_IPRatio2').text(text['ip_ratio']);
        $('#Label_Stream3').text(text['stream'] + "3");
        $('#Label_Codec3').text(text['codec'] + ":H.264");
        $('#Label_BitRate3').text(text['bit_rate']);
        $('#Label_Resolution3').text(text['resolution']);
        $('#Label_RateControl3').text(text['rate_control']);
        $('#Label_FrameRate3').text(text['frame_rate']);
        $('#Label_IPRatio3').text(text['ip_ratio']);
        $('#Span_Apply').text(text['apply']);
        $('#Span_Cancel').text(text['cancel']);

        $('#Label_CameraID').text(text['camera_id']);
        $('#Label_Location').text(text['location']);
        $('#Label_GroupName').text(text['group_name']);
        $('#Label_NDIHX').text(text['ndi|hx']);
        $('#Label_Multicast').text(text['multicast']);
        $('#Label_IPSetting').text(text['ip_setting']);
        $('#Label_Netmask').text(text['netmask']);
        $('#Span_ApplyNDI').text(text['apply']);
        $('#Span_CancelNDI').text(text['cancel']);

        $('#Label_NDI_HB_CameraID').text(text['camera_id']);
        $('#Label_NDI_HB_Location').text(text['location']);
        $('#Label_DHCP').text(text['dhcp']);
        $('#Label_IPv4Address').text(text['ipv4_address']);
        $('#Label_IPv4Netmask').text(text['ipv4_netmask']);
        $('#Label_Gateway').text(text['gateway']);
        $('#Label_DNS').text(text['dns']);
        $('#Label_MACAddress').text(text['mac_address']);
        $('#Label_NDI_HB_Multicast').text(text['multicast']);
        $('#Label_NDI_HB_IPSetting').text(text['ip_setting']);
        $('#Label_NDI_HB_Netmask').text(text['netmask']);
        $('#Label_TimeToLive').text(text['time_to_live']);
        $('#Span_ApplyNDIHB').text(text['apply']);
        $('#Span_CancelNDIHB').text(text['cancel']);

    } else if (page == "Div_LeftSystemDevice") {
        $('#Label_Device').text(text['device']);
        $('#Label_CameraID').text(text['camera_id']);
        $('#Label_Location').text(text['location']);
        $('#Span_Apply').text(text['apply']);
        $('#Span_Cancel').text(text['cancel']);

    } else if (page == "Div_LeftSystemOutput") {
        $('#Label_Output').text(text['output']);
        $('#Label_Resolution').text(text['resolution']);
        $('#Label_OutputSource').text(text['output_source']);
        $('#Label_HDMIFormat').text(text['hdmi_format']);
        $('#Label_UVC').text(text['uvc']);
        $('#Label_Codec').text(text['codec']);
        $('#Label_UVC_Resolution').text(text['resolution']);
        $('#Label_FrameRate').text(text['frame_rate']);
        $('#Label_Overlay').text(text['overlay']);
        $('#Label_TopLeft').text(text['top_left']);
        $('#Label_TopRight').text(text['top_right']);
        $('#Span_Apply').text(text['apply']);
        $('#Span_Cancel').text(text['cancel']);

    } else if (page == "Div_LeftSystemNetwork") {
        $('#Label_Network').text(text['network']);
        $('#A_tabNetwork').text(text['network']);
        $('#A_tabTrackingDataOutput').text(text['tracking_data_output']);
        $('#Label_DHCP').text(text['dhcp']);
        $('#Label_IPAddress').text(text['ip_address']);
        $('#Label_Netmask').text(text['netmask']);
        $('#Label_Gateway').text(text['gateway']);
        $('#Label_DNS').text(text['dns']);
        $('#Label_MACAddress').text(text['mac_address']);
        $('#Label_HTTPPort').text(text['http_port']);
        $('#Label_HTTPSPort').text(text['https_port']);
        $('#Span_Apply').text(text['apply']);
        $('#Span_Cancel').text(text['cancel']);

        $('#Label_FreeD').text(text['freed']);
        $('#Label_Enable').text(text['enable']);
        $('#Label_SerialOutput').text(text['serial_output']);
        $('#Label_IPOutput').text(text['ip_output']);
        $('#Label_DestinationIP').text(text['destination_ip']);
        $('#Label_Port').text(text['port']);
        $('#Span_ApplyFreeD').text(text['apply']);
        $('#Span_CancelFreeD').text(text['cancel']);

    } else if (page == "Div_LeftSystemSecurity") {
        $('#Label_Security').text(text['security']);
        $('#Label_802p1x_setting').text(text['_802p1x_setting']);
        $('#Label_Enable').text(text['enable']);
        $('#Label_EAP_Identify').text(text['eap_identify']);
        $('#Label_EAP_Password').text(text['eap_password']);
        $('#Label_EAP_method').text(text['eap_method']);
        $('#Label_Import').text(text['import']);
        $('#Span_Choose_File').text(text['choose_file']);
        $('#Label_CA_certificate').text(text['ca_certificate']);
        $('#Label_Issuer_DN').text(text['issuer_dn']);
        $('#Label_Subject_DN').text(text['subject_dn']);
        $('#Label_Available_period').text(text['available_period']);
        $('#Span_Apply').text(text['apply']);
        $('#Span_Cancel').text(text['cancel']);

    } else if (page == "Div_LeftSystemDateTime") {
        $('#Label_DateTime').text(text['date_time']);
        $('#Label_TimeinCamera').text(text['time_in_camera']);
        $('#Label_Date').text(text['date']);
        $('#Label_Time').text(text['time']);
        $('#Label_TimeSetting').text(text['time_setting']);
        $('#Label_ManualDate').text(text['date']);
        $('#Label_ManualHours').text(text['hours']);
        $('#Label_ManualMinutes').text(text['minutes']);
        $('#Label_ManualSeconds').text(text['seconds']);
        $('#Label_SNTPserver').text(text['sntp_server']);
        $('#Label_TimeZone').text(text['time_zone']);
        $('#Label_AutomaticallyAdjustforDaylightSavingTime').text(text['automatically_adjust_for_daylight_saving_time']);
        $('#Span_Apply').text(text['apply']);
        $('#Span_Cancel').text(text['cancel']);

    } else if (page == "Div_LeftSystemUser") {
        $('#Label_User').text(text['user']);
        $('#Label_UserName').text(text['user_name']);
        $('#Label_AuthorizationMode').text(text['authorization_mode']);
        $('#Span_EDIT').text(text['edit']);
        $('#Span_DEL').text(text['del']);
        $('#Label_AddUser').text(text['add_user']);
        $('#Label_Add_UserName').text(text['user_name']);
        $('#Label_Add_NewPassword').text(text['new_password']);
        $('#Label_Add_ConfirmPassword').text(text['confirm_password']);
        $('#Label_Add_AuthorizationMode').text(text['authorization_mode']);
        $('#Span_Add_Apply').text(text['apply']);
        $('#Span_Add_Cancel').text(text['cancel']);
        $('#Label_EditUser').text(text['edit_user']);
        $('#Label_Edit_UserName').text(text['user_name']);
        $('#Label_Edit_AdministratorPassword').text(text['administrator_password']);
        $('#Label_Edit_NewPassword').text(text['new_password']);
        $('#Label_Edit_ConfirmPassword').text(text['confirm_password']);
        $('#Label_Edit_AuthorizationMode').text(text['authorization_mode']);
        $('#Span_Edit_Apply').text(text['apply']);
        $('#Span_Edit_Cancel').text(text['cancel']);
        $('#Label_ConfirmDelete').text(text['confirm_delete']);
        $('#Label_Password').text(text['password']);
        $('#Span_Del_Apply').text(text['apply']);
        $('#Span_Del_Cancel').text(text['cancel']);

    } else if (page == "Div_LeftSystemControl") {
        $('#Label_Control').text(text['control']);
        $('#Label_ControlPort').text(text['control_port']);
        $('#Label_BaudRate').text(text['baud_rate']);
        $('#Label_Protocol').text(text['protocol']);
        $('#Label_VISCAAddress').text(text['visca_address']);
        $('#Label_PelcoDAddress').text(text['pelco_d_address']);
        $('#Label_TallyLamp').text(text['tally_lamp']);
        $('#Label_TallyCMMDMode').text(text['tally_cmmd_mode']);
        $('#Span_Apply').text(text['apply']);
        $('#Span_Cancel').text(text['cancel']);

    } else if (page == "Div_LeftMaintenance") {
        $('#Label_Maintenance').text(text['maintenance']);
        $('#Label_FirmwareUpdate').text(text['firmware_update']);
        $('#Span_Upgrade').text(text['upgrade']);
        $('#Label_FactoryReset').text(text['factory_reset']);
        $('#Span_Reset').text(text['reset']);
        $('#Label_SettingProfile').text(text['setting_profile']);
        $('#Span_Save').text(text['save']);
        $('#Span_Load').text(text['load']);
        $('#Label_ErrorLog').text(text['error_log']);
        $('#Span_Clean').text(text['clean']);

    } else if (page == "Div_LeftMaintenanceReboot") {
        $('#Label_Reboot').text(text['reboot']);
        $('#Span_Reboot').text(text['reboot']);
        $('#Label_Disable').text(text['disable']);
        $('#Label_Enable').text(text['enable']);
        $('#Label_DailyRebootTime').text(text['daily_reboot']);
        $('#Label_TimingRebootTime').text(text['timing_reboot']);
        $('#Span_Apply').text(text['apply']);
        $('#Span_Cancel').text(text['cancel']);

    } else if (page == "Div_LeftAbout") {
        $('#Label_Manufacturer').text(text['manufacturer'] + " :");
        $('#Label_Model_Name').text(text['model_name'] + " :");
        $('#Label_FirmwareVer').text(text['firmware_ver'] + " :");
        $('#Label_DetailInformation').text(text['detail_information'] + " :");
        $('#Label_MACAddress').text(text['mac_address'] + " :");
        $('#Label_SerialNumber').text(text['serial_number'] + " :");
        $('#Label_Uptime').text(text['uptime'] + " :");
    }
}
